/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.utils.ModUtils;
import com.powerutils.BlockEntityFEConverter;
import com.powerutils.BlockEntityQEConverter;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum BlockPowerConverter implements MultiBlockEntity
{
    power_utilities_fe(BlockEntityFEConverter.class, 0),
    power_utilities_qe(BlockEntityQEConverter.class, 1);

    private final Class<? extends BlockEntityBase> teClass;
    private final int itemMeta;
    private final Rarity rarity;
    private BlockEntityBase dummyTe;
    private BlockState defaultState;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends BlockEntityBase>> blockType;
    int idBlock;

    private BlockPowerConverter(Class<? extends BlockEntityBase> teClass, int itemMeta) {
        this(teClass, itemMeta, Rarity.UNCOMMON);
    }

    private BlockPowerConverter(Class<? extends BlockEntityBase> teClass, int itemMeta, Rarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
    }

    public boolean hasUniqueName() {
        return true;
    }

    public String getUniqueName() {
        return "powerutils.powerutils." + this.name();
    }

    public int getIDBlock() {
        return this.idBlock;
    }

    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    public void buildDummies() {
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (BlockEntityBase)this.teClass.getConstructors()[0].newInstance(BlockPos.ZERO, this.defaultState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    public void setType(DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends BlockEntityBase>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    public BlockEntityType<? extends BlockEntityBase> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    public String getMainPath() {
        return "converter";
    }

    public String getName() {
        return this.name();
    }

    public int getId() {
        return this.itemMeta;
    }

    public boolean hasItem() {
        return true;
    }

    public Class<? extends BlockEntityBase> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return false;
    }

    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.allFacings;
    }

    public float getHardness() {
        return 3.0f;
    }

    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Machine;
    }

    public boolean allowWrenchRotating() {
        return true;
    }

    public BlockEntityBase getDummyTe() {
        return this.dummyTe;
    }
}

